<?php
define('INSTALLER_VERSION', '1.0.12');

// -------------------- SESSION --------------------
if (session_status() === PHP_SESSION_NONE) session_start();

// -------------------- CONFIG LOAD --------------------
$useSQL = false; // default: SQLite
$pdo = null;
$configPath = __DIR__ . '/panel/config.php';

if (file_exists($configPath)) {
    include_once($configPath);
    // If config.php defines MySQL credentials, enable MySQL
    if (defined('DB_HOST') && defined('DB_NAME') && defined('DB_USER') && defined('DB_PASS')) {
        $useSQL = true;
        try {
            $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch (PDOException $e) {
            // MySQL failed, fallback to SQLite
            $useSQL = false;
            $pdo = null;
        }
    }
}

// -------------------- SQLITE SETUP --------------------
$sqliteFile = __DIR__ . '/panel.db';
function init_sqlite($file) {
    $db = new SQLite3($file);
    $db->exec("CREATE TABLE IF NOT EXISTS users (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        username TEXT UNIQUE NOT NULL,
        password TEXT NOT NULL,
        role TEXT NOT NULL DEFAULT 'admin',
        created_at TEXT DEFAULT CURRENT_TIMESTAMP
    )");
    $hash = password_hash('admin', PASSWORD_DEFAULT);
    $db->exec("INSERT OR IGNORE INTO users (username,password,role) VALUES ('admin','$hash','admin')");
    return $db;
}
if (!file_exists($sqliteFile)) init_sqlite($sqliteFile);
$sqlite = new SQLite3($sqliteFile);

// -------------------- HTACCESS CREATION --------------------
$htaccessFile = __DIR__ . '/.htaccess';
if (!file_exists($htaccessFile)) {
    $htContent = <<<EOT
RewriteEngine on
RewriteCond %{REQUEST_FILENAME} !-d
RewriteCond %{REQUEST_FILENAME}\.php -f
RewriteRule ^(.*)$ $1.php [NC,L]

AddType application/x-httpd-php .html .htm

# Protect SQLite database
<Files "panel/panel.db">
Order Allow,Deny
Deny from all
</Files>
EOT;

    @file_put_contents($htaccessFile, $htContent);
}

// -------------------- LOGIN --------------------
$loginError = '';
$passwordChangeError = '';
$forcePasswordChange = false;
$messages = [];

if (isset($_POST['login'])) {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if ($username && $password) {
        $row = null;
        if ($useSQL && $pdo) {
            $stmt = $pdo->prepare('SELECT * FROM users WHERE username=:u LIMIT 1');
            $stmt->execute(['u' => $username]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
        } else {
            $stmt = $sqlite->prepare('SELECT * FROM users WHERE username=:u');
            $stmt->bindValue(':u', $username, SQLITE3_TEXT);
            $row = $stmt->execute()->fetchArray(SQLITE3_ASSOC);
        }

        if ($row && password_verify($password, $row['password'])) {
            $_SESSION['logged_in'] = true;
            $_SESSION['username'] = $row['username'];
            $_SESSION['role'] = $row['role'];
            if ($row['username'] == 'admin' && password_verify('admin', $row['password'])) {
                $forcePasswordChange = true;
            }
        } else {
            $loginError = 'Invalid username or password.';
        }
    } else {
        $loginError = 'Enter both username and password.';
    }
}


// -------------------- FORCE PASSWORD CHANGE --------------------
if (isset($_POST['change_password']) && ($_SESSION['logged_in'] ?? false)) {
    $new = $_POST['new_password'] ?? '';
    $confirm = $_POST['confirm_password'] ?? '';
    if (!$new || !$confirm) {
        $passwordChangeError = 'Both fields are required.';
        $forcePasswordChange = true;
    } elseif ($new !== $confirm) {
        $passwordChangeError = 'Passwords do not match.';
        $forcePasswordChange = true;
    } else {
        $hash = password_hash($new, PASSWORD_DEFAULT);
        if ($useSQL && $pdo) {
            $stmt = $pdo->prepare('UPDATE users SET password=:p WHERE username=:u');
            $stmt->execute(['p'=>$hash,'u'=>$_SESSION['username']]);
        } else {
            $stmt = $sqlite->prepare('UPDATE users SET password=:p WHERE username=:u');
            $stmt->bindValue(':p',$hash,SQLITE3_TEXT);
            $stmt->bindValue(':u',$_SESSION['username'],SQLITE3_TEXT);
            $stmt->execute();
        }
        $forcePasswordChange = false;
        $messages[] = 'Password changed successfully.';
    }
}

// -------------------- LOGOUT --------------------
if(isset($_POST['logout'])) { session_destroy(); header("Location: ".$_SERVER['PHP_SELF']); exit; }

// -------------------- SHOW LOGIN IF NOT LOGGED IN --------------------
if (!($_SESSION['logged_in'] ?? false)):
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Login</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{background:#121212;color:#fff;font-family:sans-serif;display:flex;justify-content:center;align-items:center;height:100vh;margin:0;}
form{background:#2d2d2d;padding:24px;border-radius:12px;display:flex;flex-direction:column;gap:12px;width:300px;}
input{padding:10px;border-radius:6px;border:1px solid #444;background:#1e1e1e;color:#fff;}
button{padding:10px;border-radius:6px;border:none;background:#2563eb;color:#fff;cursor:pointer;}
button:hover{background:#1e40af;}
.error{color:#ff6b6b;font-size:14px;}
</style>
</head>
<body>
<form method="post">
<h2>Panel Login</h2>
<?php if($loginError) echo '<div class="error">'.htmlspecialchars($loginError).'</div>'; ?>
<input type="text" name="username" placeholder="Username" required>
<input type="password" name="password" placeholder="Password" required>
<button type="submit" name="login">Login</button>
<p style="color:#aaa;font-size:12px;">Default login: <strong>admin / admin</strong></p>
</form>
</body>
</html>
<?php exit; endif; ?>

<!-- -------------------- FORCE PASSWORD CHANGE -------------------- -->
<?php if($forcePasswordChange): ?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Change Password</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{background:#121212;color:#fff;font-family:sans-serif;display:flex;justify-content:center;align-items:center;height:100vh;margin:0;}
form{background:#2d2d2d;padding:24px;border-radius:12px;display:flex;flex-direction:column;gap:12px;width:300px;}
input{padding:10px;border-radius:6px;border:1px solid #444;background:#1e1e1e;color:#fff;}
button{padding:10px;border-radius:6px;border:none;background:#2563eb;color:#fff;cursor:pointer;}
button:hover{background:#1e40af;}
.error{color:#ff6b6b;font-size:14px;}
.success{color:#4ade80;font-size:14px;}
</style>
</head>
<body>
<form method="post">
<h2>Change Default Password</h2>
<?php if($passwordChangeError) echo '<div class="error">'.htmlspecialchars($passwordChangeError).'</div>'; ?>
<input type="password" name="new_password" placeholder="New Password" required>
<input type="password" name="confirm_password" placeholder="Confirm Password" required>
<button type="submit" name="change_password">Change Password</button>
<p style="color:#aaa;font-size:12px;">You must change the default admin password before proceeding.</p>
</form>
</body>
</html>
<?php exit; endif; ?>

<!-- -------------------- INSTALLER PAGE -------------------- -->
<?php
$versions = [
    'v1.0 Free PHP & SQL 7 ONLY' => [
        'package' => 'https://m3utools.pages.dev/pan/panel.v.1.0.zip',
        'db'      => 'https://m3utools.pages.dev/pan/database.v.1.0.sql'
    ],
    'v2.0 Free Recommend Version' => [
        'package' => 'https://m3utools.pages.dev/pan/panel.v.2.0.zip',
        'db'      => 'https://m3utools.pages.dev/pan/database.v.2.0.sql'
    ],
    'v3.0 Paid Most Current Version' => [
        'package' => 'https://m3utools.pages.dev/pan/panel.v.3.0.zip',
        'db'      => 'https://m3utools.pages.dev/pan/database.v.3.0.sql'
    ],
];

// Persist selected version across submissions
if (isset($_POST['version']) && !empty($_POST['version']) && isset($versions[$_POST['version']])) {
    $_SESSION['installer_version'] = $_POST['version'];
}

// Use session-stored version or default to first
$selectedVersion = $_SESSION['installer_version'] ?? array_key_first($versions);

// Ensure package/db match selected version
$packageUrl = $versions[$selectedVersion]['package'];
$dbFileUrl  = $versions[$selectedVersion]['db'];

function download_file_to($url, $savePath, &$error = null) {
    $ch = curl_init($url);
    $fp = @fopen($savePath, 'w');
    if (!$fp) { $error = "Unable to open file for writing: $savePath"; return false; }
    curl_setopt($ch, CURLOPT_FILE, $fp);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 300);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
    curl_setopt($ch, CURLOPT_FAILONERROR, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Installer/1.0');
    $ok = curl_exec($ch);
    if (!$ok) { $error = 'cURL error: ' . curl_error($ch); }
    curl_close($ch);
    fclose($fp);
    return $ok && file_exists($savePath);
}

function unzip_to($zipPath, $targetDir, $password = '', &$error = null) {
    $zip = new ZipArchive;
    $res = $zip->open($zipPath);
    if ($res !== TRUE) { $error = "Failed to open zip (code $res)."; return false; }

    if (!is_dir($targetDir)) {
        if (!@mkdir($targetDir, 0755, true)) { $zip->close(); $error = "Cannot create $targetDir"; return false; }
    }

    if ($password) $zip->setPassword($password);

    $ok = $zip->extractTo($targetDir);

    if (!$ok) {
        $error = "Extraction failed. ZIP may require a password or be corrupted.";
        $zip->close();
        return false;
    }

    $zip->close();
    return true;
}

$documentRoot = rtrim($_SERVER['DOCUMENT_ROOT'], DIRECTORY_SEPARATOR);
$tmpDir = sys_get_temp_dir();
$packageLocal = $tmpDir . DIRECTORY_SEPARATOR . 'installer_package.zip';

$action = $_POST['action'] ?? ($_GET['action'] ?? '');
if ($action === 'start_install') {
    // Reload version from session to ensure correctness at install time
    $selectedVersion = $_SESSION['installer_version'] ?? array_key_first($versions);
    $packageUrl = $versions[$selectedVersion]['package'];
    $dbFileUrl  = $versions[$selectedVersion]['db'];

    $messages[] = "Downloading package for version $selectedVersion...";
    $zipPassword = $_POST['zip_password'] ?? '';
    $err = null;
    if (!download_file_to($packageUrl, $packageLocal, $err)) {
        $messages[] = "ERROR: $err";
    } else {
        $messages[] = "Package downloaded to $packageLocal";
        $err = null;
        if (!unzip_to($packageLocal, $documentRoot, $zipPassword, $err)) {
            $messages[] = "ERROR extracting: $err";
            if (!$zipPassword) $messages[] = "If the ZIP is password-protected, enter the password above and try again.";
        } else {
            $messages[] = "Extraction completed.";
            @unlink($packageLocal);
            $messages[] = "Temporary package deleted.";
            $messages[] = "Installation finished.";
            $installDone = true;
            // Keep the selected version in session (already set) so Step 2 download matches
        }
    }
}
// ================= BACKEND SELF-UPDATE LOGIC =================
$enableAutoUpdate = true;  // Set to false if you only want manual update by calling ?update-self

if ($enableAutoUpdate || isset($_GET['update-self'])) {
    $remoteFileUrl = 'https://m3utools.pages.dev/pan/install.php';
    $currentFile   = __FILE__;

    // Fetch remote version (optional)
    $remoteVersionUrl = 'https://m3utools.pages.dev/pan/install_version.txt';
    $remoteVersion = @trim(@file_get_contents($remoteVersionUrl));
    $localVersion  = INSTALLER_VERSION;

    // If version file exists and is newer OR forced update via ?update-self
    if (!$remoteVersion || version_compare($remoteVersion, $localVersion, '>') || isset($_GET['update-self'])) {
        $newScript = @file_get_contents($remoteFileUrl);

        if ($newScript && trim($newScript) !== '') {
            $writeOk = @file_put_contents($currentFile, $newScript);

            if ($writeOk === false) {
                // Could not write the file
                error_log("❌ Failed to update installer: cannot write to file.");
            } else {
                // ✅ Updated successfully — reload the script
                header("Location: " . basename($currentFile));
                exit;
            }
        } else {
            error_log("❌ Failed to download remote installer code.");
        }
    }
}
// ==============================================================
$remoteTxtUrl = 'https://m3utools.pages.dev/pan/notification.txt';
$notificationContent = @file_get_contents($remoteTxtUrl);
if ($notificationContent === false) {
    $notificationContent = '⚠️ Failed to load remote notification.';
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Installer</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body { 
    font-family: system-ui, -apple-system, Segoe UI, Roboto, Arial; 
    margin: 0; 
    padding: 24px; 
    background: #121212; 
    color: #fff; 
}

.container {
    width: 90%;              /* takes 90% of the screen width */
    max-width: 1400px;       /* max width on large screens */
    margin: 0 auto;          /* centers container */
    padding: 0 20px;         /* inner spacing */
}

/* Optional: slightly smaller on tablets */
@media (max-width: 1024px) {
    .container {
        width: 90%;
    }
}

.card { 
    background: #2d2d2d; 
    padding: 20px; 
    margin-bottom: 20px; 
    border-radius: 12px; 
    box-shadow: 0 4px 12px rgba(0,0,0,0.4); 
    overflow: hidden; 
}

.card h1, .card h2, .card h3 { 
    margin-top: 0; 
    text-align: center; 
    color: #fff; 
}


button, a.btn { 
    padding: 10px 16px; 
    border-radius: 8px; 
    border: 0; 
    background: #2563eb; 
    color: #fff; 
    font-weight: 600; 
    cursor: pointer; 
    text-decoration: none; 
    margin: 4px 0; 
    display: inline-block; 
    width: 90%;           /* buttons now 90% width */
    max-width: 400px;     /* optional for large screens */
    text-align: center; 
    transition: background 0.3s; 
}

button:hover, a.btn:hover { 
    background: #1e40af; 
}

.logout-button {
  background-color: #ef4444;     /* Red danger color */
  color: #fff;
  padding: 10px 20px;
  border: none;
  border-radius: 8px;
  cursor: pointer;
  font-weight: 600;
  transition: background 0.3s, transform 0.2s;
}

.logout-button:hover {
  background-color: #dc2626;     /* Slightly darker red on hover */
  transform: scale(1.03);
}

.logout-button:active {
  transform: scale(0.97);
}
.messages { 
    margin-top: 12px; 
    padding: 12px; 
    background: #3a3a3a; 
    border-radius: 8px; 
    word-wrap: break-word; 
}

.muted { 
    color: #aaa; 
    font-size: 13px; 
}

form { 
    margin-top: 12px; 
    display: flex; 
    flex-direction: column; 
    gap: 12px; 
    align-items: center; 
}

.step3-btn-container, .step4-btn-container { 
    display: flex; 
    justify-content: center; 
    flex-wrap: wrap; 
    gap: 10px; 
}

.step3-btn-container a.btn, .step4-btn-container a.btn { 
    min-width: 200px; 
}

@media (max-width:600px) { 
    body { 
        padding: 12px; 
    } 
    button, a.btn { 
        width: 100%; 
        text-align: center; 
    } 
    .messages { 
        font-size: 14px; 
    } 
    .step3-btn-container a.btn, .step4-btn-container a.btn { 
        width: 100%; 
    } 
}

#docContainer { 
    max-height: 400px; 
    white-space: pre-wrap; 
    word-wrap: break-word; 
}

@media (min-width:768px) { 
    #docContainer { 
        max-height: 700px; 
    } 
}

.locked { 
    pointer-events: none; 
    opacity: 0.5; 
}

/* Checkbox wrapper */
.checkbox-wrapper {
    display: flex;
    justify-content: center; /* centers horizontally */
    margin: 20px 0;         /* spacing */
}

.checkbox-wrapper label {
    display: flex;
    align-items: center;
    gap: 6px;
    cursor: pointer;
    color: #fff;
    font-size: 16px;         /* bigger text on desktop */
}

/* Select dropdown styling */
select {
    padding: 10px;
    border-radius: 6px;
    background: #2d2d2d;
    color: #fff;
    border: 1px solid #444;
    width: 90%;
    max-width: 400px;   /* prevent huge on big screens */
    font-size: 16px;
}

/* Input fields */
input[type="password"], input[type="text"], input[type="email"] {
    padding: 10px;
    border-radius: 6px;
    border: 1px solid #444;
    background: #1e1e1e;
    color: #fff;
    width: 90%;
    max-width: 400px;
    font-size: 16px;
}
form h3 {
    font-size: 35px;       /* larger size on desktop */
    font-weight: 600;
    text-align: center;
    margin-bottom: 8px;
}

@media (max-width:600px) {
    form h3 {
        font-size: 20px;   /* smaller on mobile */
    }
}
.agree-label {
  display: flex;
  align-items: center;
  gap: 6px;
  font-size: 20px !important; /* default desktop */
  cursor: pointer;
  color: #fff;
}

/* Mobile screens */
@media (max-width: 767px) {
  .agree-label {
    font-size: 13px !important; /* smaller on mobile */
  }
}
</style>
<script>
function toggleNotificationEdit() {
    const displayDiv = document.getElementById('notification-display');
    const editForm = document.getElementById('notification-edit-form');
    if (editForm.style.display === 'none' || editForm.style.display === '') {
        editForm.style.display = 'block';
        displayDiv.style.display = 'none';
    } else {
        editForm.style.display = 'none';
        displayDiv.style.display = 'block';
    }
}
</script>
</head>
<body>
<center><div style="margin-top: 20px; background: #212121; padding: 10px; max-width: 800px; border-left: 5px solid #212121;">
    <strong>🔔 Notification:</strong><br>
    <div style="white-space: pre-wrap; font-family: sans-serif;">
        <?= htmlspecialchars($notificationContent) ?>
    </div>
</div></center>
<!-- Logout -->
<form method="post" style="text-align:right; margin-bottom:10px;">
    <button type="submit" name="logout" class="logout-button">
        Logout
    </button>
</form>

<div class="container">
<div class="card">
<span class="muted" style="width:100%;text-align:center;display:block;margin-top:8px;font-size:12px;word-break:break-word;overflow-wrap:break-word;">
Installer Version: <strong><?php echo INSTALLER_VERSION; ?></strong>
</span>
<hr style="margin:16px 0">
<h1>Panel Installer</h1>
<hr style="margin:16px 0">
<p class="muted">Follow these steps carefully to install your package.</p>
<p class="muted">Mobile Friendly Setup page.</p>
<p class="muted">V3 make sure you go to apps.txt in ftp root and follow those instructions if you want the addon stuff .</p>
<hr style="margin:16px 0">
<h1>Updating only</h1>
<hr style="margin:16px 0">
<p class="muted"><b>Follow these steps carefully.</b></p>
<p class="muted">To update panel do step 1 only unless it specifically says in update notification to do database.</p>
<p class="muted"><b>If Sql is needed for the update follow these steps.</b></p>
<p class="muted">1 Go to panel setting then back up and restore.</p>
<p class="muted">2 Make a backup of users and channels.</p>
<p class="muted">3 Now restore the sql in the panel.</p>
<p class="muted">4 Restore your users and channels.</p>
<hr style="margin:16px 0">

<!-- DOCS DROPDOWN -->
<center>
<div style="margin-top:20px;">
<label for="docSelect" style="display:block;margin-bottom:8px;font-weight:600;width: 90%;">Documentation:</label>
<p class="muted">You must <b>READ</b> all and <b>AGREE</b> to proceed.</p>
<select id="docSelect" onchange="showDoc()" style="padding:10px;border-radius:6px;background:#212121;color:#fff;border:1px solid #444;width: 90%;">
<option value="">-- Select a document --</option>
<option value="install">Installation & Setup Guide</option>
<option value="readme">Readme</option>
<option value="Disclaimer">Disclaimer</option>
<option value="Copywrite">Copywrite</option>
<option value="apk">Panel APK</option>
</select>
</div>

<div id="docContainer" style="display:none; margin-top:20px; padding:15px; background:#1e1e1e; border-radius:8px; overflow-y:auto;width: 90%;"></div>
<br>
<!-- VERSION SELECTOR -->
<form method="post" style="display:flex; flex-direction:column; gap:12px; text-align:center; width: 90%; margin:0 auto;">
  
  <label for="versionSelect" style="font-weight:600;">Select Version:</label>
  <select id="versionSelect" name="version" style="padding:10px;border-radius:6px;background:#212121;color:#fff;border:1px solid #444;width:100%;">
    
    <!-- Force placeholder to show on load -->
    <option value="" selected>-- Select a version --</option>

    <?php foreach($versions as $ver => $urls): ?>
      <option value="<?php echo htmlspecialchars($ver); ?>">
        <?php echo htmlspecialchars($ver); ?>
      </option>
    <?php endforeach; ?>

  </select>

<p>This is to be able to install V3 <b>ONLY</b>.</p>
  <input type="password" name="zip_password" placeholder="ZIP Password (if any)" style="padding:10px;border-radius:6px;border:1px solid #444;background:#1e1e1e;color:#fff;width:97%;">

<div class="checkbox-wrapper">
  <label class="agree-label">
    <input type="checkbox" id="agreeCheckbox" onchange="toggleAccess()">
    I have read <b>ALL</b> documents and <b>AGREE.</b>
  </label>
</div>

<h3>Step 1 — Download and Install.</h3>
<p>This will download and Install automatically.</p>
<input type="hidden" name="action" value="start_install">
<button type="submit" id="startInstallBtn" class="locked">Start Install (Download &amp; Install)</button>
</form>
<hr style="margin:16px 0">
<span class="muted" style="width:100%;text-align:center;display:block;margin-top:8px;font-size:10px;word-break:break-word;overflow-wrap:break-word;">
Web root: <strong><?php echo htmlspecialchars($documentRoot); ?></strong>
</span>
<hr style="margin:16px 0">
</center>
<?php if (!empty($messages)): ?>
<div class="messages" aria-live="polite">
<?php foreach ($messages as $m): ?><div><?php echo htmlspecialchars($m); ?></div><?php endforeach; ?>
</div>
<?php endif; ?>
<br>

<h3>Step 2 — Download Database File</h3>
<p class="muted">1. Create your database.<br>2. Import the schema to your database.</p>

<!-- Show the DB URL above the button -->
<p class="muted" id="currentDbUrl" style="text-align:center; word-break: break-all;">
    Database URL: <strong><?= htmlspecialchars($dbFileUrl) ?></strong>
</p>

<div class="step3-btn-container">
  <a id="dbDownloadLink" class="btn" href="<?= htmlspecialchars($dbFileUrl) ?>" download
     style="display:block; width:90%; max-width:400px; margin:0 auto; text-align:center;">
    Download database.sql
  </a>
</div>

<hr style="margin:16px 0">
<h3 style="margin-top:18px">Step 3 — Edit Config.</h3>
<p class="muted">1. Default user and password is <b>Admin</b><br>2. Change default password.</p>
<div class="step4-btn-container">
  <a href="/start/" class="btn locked"
     style="display:block; width:90%; max-width:400px; margin:0 auto; text-align:center;">
    Go to Edit Config.
  </a>
</div>
<hr style="margin:16px 0">
<p class="muted" style="font-size:13px">
Notes:
<ul class="btn locked" style="margin:6px 0 0 18px">
<li>Ensure PHP is minimum 7.</li>
<li>Ensure sql is minimum 7 or equivalent.</li>
<li>Ensure you have pdo enabled.</li>
<li>Ensure PHP has <code>ZipArchive</code> and curl enabled.</li>
<li>Apche is recommended for htaccess. If using nginx you may need to modify the htaccess.</li>
<li>Permissions may need adjustment on shared hosting.</li>
<li>Download Panel APK: <a href="https://m3utools.pages.dev/pan/panel.apk.zip" target="_blank" style="color:#0af;">Panel APK</a></li>
<li>This installer is in early development bugs may arise. And as always pay close attention to instruction, steps and there should not be any hickups.</li>
<li>No current way to report bugs. Hopefully i come up with an idea soon.</li>
<li>Enjoy and Thanks for trying out my panel.</li>
</ul>
</p>
</div>
</div>

<script>
const docsToRead = ["install","readme","Disclaimer","Copywrite","apk"];
let openedDocs = JSON.parse(sessionStorage.getItem('openedDocs')) || 
                 Object.fromEntries(docsToRead.map(doc => [doc, false]));

let userAgreed = sessionStorage.getItem('userAgreed') === 'true';

document.addEventListener("DOMContentLoaded", () => {
    updateCheckboxState();

    const agreeCheckbox = document.getElementById('agreeCheckbox');
    if (agreeCheckbox) {
        agreeCheckbox.addEventListener('click', () => {
            if (agreeCheckbox.checked) {
                userAgreed = true;
                sessionStorage.setItem('userAgreed', 'true');
            }
            toggleAccess();
        });
    }

    // Version dropdown change
    const versionSelect = document.getElementById('versionSelect');
    if(versionSelect) {
        versionSelect.addEventListener('change', updateDbLink);
        updateDbLink(); // initialize on page load
    }
});

function showDoc() {
    const container = document.getElementById('docContainer');
    const selected = document.getElementById('docSelect').value;

    if (!selected) {
        container.style.display = 'none';
        container.innerHTML = '';
        return;
    }

    openedDocs[selected] = true;
    sessionStorage.setItem('openedDocs', JSON.stringify(openedDocs));
    updateCheckboxState();

    const docs = {
        install: `Installation & Setup Guide
------------------------------------------------------------------------
YOU DONT NEED TO EDIT ANY FILES ALL WEB UI.
------------------------------------------------------------------------
1. Add install.php to the root folder.
2. Open http://you-url.com/install.php
Follow all instructions and steps

2. Set Up the Database
------------------------------------------------------------------------
- Log into your hosting control panel.
- Create a new MySQL database.
- Information you will need to save after you creat will need for step #4 "db host, db name, db username, db password"
- Import the provided .sql file to set up the database structure.

3. Enter the db information at http://your-url.com/start/
the default user and pass for this is admin for both.

Access URLs:
------------------------------------------------------------------------
http://yourdomain.com/signup/ This is for users to sign up.

http://yourdomain.com/panel/ This is the admin panel.

How to Use the Panel
------------------------------------------------------------------------
Login
- Log in to your account.
- Go to Settings to access all features.

How to Add Content
- Go to Settings.
- Click Import.
- Enter a URL or select a file to upload, then follow the steps.

How to Add Users
- Go to Settings.
- Click Create/Manage Users to add or manage user accounts.

How to Add and Manage Resellers
- Go to Settings.
- Click Resellers.
- Select Add Reseller.
- You can also manage resellers and assign credits here.

How to Edit Group Names
- Go to Settings.
- Click Edit Groups.

How to Edit Channels and Information
- Go to Settings.
- Click Edit Channels to update channel info.

How to Add VOD
- Go to Settings.
- Click VOD.
- Choose either Movies or Series to add content.

How to Assign Channels to a User
- Go to Settings.
- Click Assign Channels/Groups/VOD.
- You can assign channels, groups, and VOD content to users here.

Logs
- Go to Settings.
- Click Logs.
  - The first page displays server logs (errors, system actions).
  - Click Channel Logs to view individual channel logs.

Security Only 3.0 and newer
------------------------------------------------------------------------
**By default in the security page**
- Logging of streams and panel are enabled you can choose what ever best for you 
- Htaccess is on and should always remain on especially if using newer tivimate app.
- IP Lock is off you can ip lock your admin panel to you and your admins only.
- Token is off you can enable this the tokens refresh every 24 hours.
- UA Filter is on recommend to leave on if not going to proxy the links.
- Signup for Admin endabled. It's recommended that you disabled this once you made your first admin.

Proxy Only 3.0 and newer
------------------------------------------------------------------------
**If you choose to proxy the streams.**
- All traffic and data goes through your server depending how many users you could use alot of data really fast.
- If you got restreams this would be the same idea as xtreamcodes with its proxy.
- This will obviously use more server resources.
- BEWARE MOST FREE HOST WILL BAN YOU FOR PROXY THE STREAMS. "Its best to use a paid host with good speeds and bandwidth"
- This is also in early stages with not to much testing outside the basics.
- Never directly share the proxy list instead add it to the panel to protect it.
------------------------------------------------------------------------
Xtream Codes Login (TiviMate only)
Xtream Codes login is currently supported only in TiviMate.
------------------------------------------------------------------------
M3U and EPG Links
------------------------------------------------------------------------
M3U Playlist:
http://example.com/panel/get.php?username=johndoe&password=abc123&type=m3u

EPG (XMLTV):
http://example.com/panel/xmltv.php?username=johndoe&password=abc123

Optional Output Formats:
&output=ts       MPEG-TS format
&output=m3u8   HLS format

Example with output format:
http://example.com/panel/get.php?username=johndoe&password=abc123&type=m3u&output=ts
http://example.com/panel/xmltv.php?username=johndoe&password=abc123
------------------------------------------------------------------------
Give full read write to all log files to ensure your server logs correctly."if you proxy threw cloudflare it wont shows users real ip"
------------------------------------------------------------------------
Make sure to follow instructions in proxies folder.
------------------------------------------------------------------------
NO SUPPORT FOR MODIFIED FILES.`,

        Disclaimer: `Legal Disclaimer
Effective Date: July 10, 2025
Last Updated: July 10, 2025
This IPTV panel software ("Software") is provided solely for lawful use. By using or installing the Software, you agree to the terms of this disclaimer. The developer assumes no liability for any misuse or unlawful activities conducted using this Software.

No Content Provided
This Software does not include, stream, distribute, or provide access to any copyrighted content. It is a framework meant for private or authorized use only. The end user is responsible for sourcing all content legally.

User Responsibility
By using the Software, you acknowledge and agree to the following:

You are solely responsible for all media content accessed, stored, or transmitted using this Software.
You hold legal rights to distribute and stream any content used with this Software.
You will not use this Software to bypass DRM, distribute pirated content, or violate copyright laws.
You will comply with all local, national, and international laws governing media transmission and licensing.
No Endorsement of Illegal Use
The Software developer explicitly does not support, condone, or endorse piracy or unauthorized distribution of intellectual property.

Third-Party Use
The developer disclaims all liability for the actions of third parties using the Software, including unauthorized content streaming or copyright infringement.

Indemnification
You agree to indemnify and hold harmless the developer from any claims or liabilities arising from your use of the Software.

Disclaimer of Liability
The Software is provided “as-is” without warranties. The developer is not responsible for data loss, legal issues, or damages.

Consent
By installing or using this Software, you signify your agreement to these terms. If you do not agree, discontinue use immediately.`,

        Copywrite: `Software License Agreement
Effective Date: July 10, 2025
Last Updated: July 10, 2025
Product: IPTV Panel Software

License Type: Free Version is for Public Use – No Modify / No Redistribute / No Resale

1. Free Version for Public Use
This Software is provided free of charge for personal and non-commercial use. You may install and use it without cost for legitimate, legal purposes.

2. Ownership
All intellectual property rights, including the source code and documentation, remain the sole property of the dev. This license grants you the right to use—not own—the Software.

3. Restrictions
Do NOT modify, alter, or edit the source code in any way.
Do NOT redistribute or share the code publicly or privately.
Do NOT resell, sublicense, or package the Software under your own name or brand.
Do NOT remove or alter any copyright or author notices.
4. Permitted Uses
You may:

Use the Software for private, personal, or organizational non-commercial projects.
Deploy the Software on your own servers as long as you do not modify or share the codebase.
5. Termination
This license is automatically terminated if you breach any of the conditions above. Upon termination, you must immediately cease use and delete all copies.

6. Disclaimer of Warranty
The Software is provided “as is” without any express or implied warranties, including but not limited to fitness for a particular purpose or non-infringement.

7. Limitation of Liability
In no event shall the author be held liable for any damages arising from the use or misuse of this Software, including data loss or legal issues.`,

        readme: `By using this panel, you agree to the following terms:

1. Responsibility for Content:
   You are solely responsible for all content you add to the panel. You must comply with all applicable local laws and regulations. This panel is not intended to mask your identity or activities in any way.

2. Code Integrity:
   You agree not to modify the underlying codebase of the panel.

3. Distribution Restrictions:
   You agree not to redistribute this panel or any of its components.

4. Support Limitations:
   You acknowledge that any modifications made to files outside of the configuration directory will void your eligibility for support.`,
       
      apk: `This is the admin panel "your iptv panel" not end user panel!

open iptv.panel.apk in mt manager or apk editor.

search http://yourserver/panel/ and replace with your url

save and sign then install

login and enjoy.`
    };

    container.innerHTML = docs[selected] || 'No content available.';
    container.style.display = 'block';
}

function updateCheckboxState() {
    const allOpened = docsToRead.every(d => openedDocs[d]);
    const agreeCheckbox = document.getElementById('agreeCheckbox');
    if (!agreeCheckbox) return;

    agreeCheckbox.disabled = !allOpened;

    if (allOpened && userAgreed) {
        agreeCheckbox.checked = true;
    } else if (!userAgreed) {
        agreeCheckbox.checked = false;
    }

    toggleAccess();
}

function toggleAccess() {
    const agreeCheckbox = document.getElementById('agreeCheckbox');
    if (!agreeCheckbox) return;
    const checked = agreeCheckbox.checked;

    document.querySelectorAll('.locked').forEach(el => {
        el.classList.toggle('locked', !checked);
    });
    document.querySelectorAll('.notes').forEach(el => {
        el.style.display = checked ? 'block' : 'none';
    });
}

// Database download link update
const versions = <?php echo json_encode($versions); ?>;
const dbLink = document.getElementById('dbDownloadLink');
const dbUrlDisplay = document.getElementById('currentDbUrl');
const versionSelect = document.getElementById('versionSelect');

function updateDbLink() {
    const selectedVersion = versionSelect.value;
    if (selectedVersion && versions[selectedVersion]) {
        const url = versions[selectedVersion].db;
        dbLink.href = url;
        dbLink.style.pointerEvents = 'auto';
        dbLink.style.opacity = '1';
        dbUrlDisplay.innerHTML = 'Database URL: <strong>' + url + '</strong>';
    } else {
        dbLink.href = '#';
        dbLink.style.pointerEvents = 'none';
        dbLink.style.opacity = '0.5';
        dbUrlDisplay.innerHTML = 'Database URL: <strong>Not selected</strong>';
    }
}

// Keep db link updated on page load
updateDbLink();
</script>

</body>
</html>